#define vec2 float2
#define vec4 float4
#define rgb xyz
#define rgba xyzw

typedef struct
{
	int width[8];
	int height[8];
	float cur_time;
	float total_time;
	float origROI[4];
	float resultROI[4];
	float angle;
}FilterParam;

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;

static int get_global_id0(__global FilterParam* param)
{
	return get_global_id(0) - param->origROI[0]* param->width[0];
}

static int get_global_id1(__global FilterParam* param)
{
	return get_global_id(1) - param->origROI[1]* param->height[0];
}

vec4 INPUTSRC(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t ovelay1,  __global FilterParam* param, vec2 tc)
{
	return read_imagef(ovelay1, sampler, (vec2)(tc.x,tc.y) );
}

// Filter blance(splite stype)
float Parabola(float dX, float3 dCoeffs)
{
	return clamp( (dCoeffs.s0 * dX + dCoeffs.s1) * dX + dCoeffs.s2, 0.0f, 1.0f );
}

__kernel void filter_Blance(__read_only image2d_t image,   		// image buffer 1
							__write_only image2d_t retImage,   	// image result	
						    __global int* redCoeffs,
						     __global int* greenCoeffs,
						     __global int* blueCoeffs,
						    __private int m_bSrcLeft,
						    __private int m_bSplit,
						    __private int alpha)	 			// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	

	bool bSplit = m_bSplit == 1 ? true : false;
	bool bSrcLeft = m_bSrcLeft == 0 ? true : false;
	bool copyPixel = false;

	if(bSplit)
	{
		if(bSrcLeft && (w < (width / 2)))
			copyPixel = true;
		else if(!bSrcLeft && (w >= (width / 2)))
			copyPixel = true;
		else
			copyPixel = false;
	}

	float4 color = read_imagef(image, sampler, (int2)(w, h));
	
	if(copyPixel)
	{	
		float r = color.x;
		float g = color.y;
		float b = color.z;
		float a = color.w;
	
		float r0 = blueCoeffs[(int)(r*255.0f + 0.5f) ]/255.0f;
		float g0 = redCoeffs[(int)(g*255.0f + 0.5f) ]/255.0f;
		float b0 = greenCoeffs[(int)(b*255.0f + 0.5f) ]/255.0f;
		float factor = (float)(alpha)/100.0f;
	
		r = r0 * factor + r * (1.0f - factor);
		g = g0 * factor + g * (1.0f - factor);
		b = b0 * factor + b * (1.0f - factor);
		
		write_imagef(retImage, (int2)(w, h), (float4)(r, g, b, a));
	}
	else
		write_imagef(retImage, (int2)(w, h), color);

}